import { VirtualListTimelineItem } from '../components/TimelineV2/TimelineV2.types';
import { isManagerActivity } from '../components/TimelineV2/List/ItemProxy';

export const transformTimelineV1ToTimelineV2 = (item: VirtualListTimelineItem) => {
  if (isManagerActivity(item)) {
    const innerData = item.data.data;

    return {
      ...item.data,
      eType: item.etype,
      data: {
        ...innerData,
        entityType: innerData.etype,
        entityData: { ...innerData.data, ...innerData.data.data },
      },
    };
  }

  return {
    ...item.data,
    data: {
      ...item.data.data,
      eType: item.etype,
    },
  };
};
