import throttle from 'lodash/throttle';
import { saveStateToIndexedDb } from './localStorage';

const isLoad = (state) => state.root?.isLoad;

const updateLocalStorage = throttle((store) => {
  const state = store.getState();
  if (isLoad(state)) {
    saveStateToIndexedDb(state);
  }
}, 1000);

export const middleware = (store) => (next) => (action) => {
  updateLocalStorage(store);

  return next(action);
};
