import React from 'react';
import PropTypes from 'prop-types';
import css from './styles.styles.scss';
import cx from 'classnames';

const Attachment = (args) => {
  const { className, isAttachment, onClick } = args;
  
  return (
    <span
      className={cx(css.notificationsAttachment, isAttachment && css.notificationsAttachment_active, className)}
      onClick={onClick}
    >
      <i className="material-icons">attach_file</i>
    </span>
  );
};

Attachment.propTypes = {
  className: PropTypes.string,
  isAttachment: PropTypes.bool,
  onClick: PropTypes.func,
};

Attachment.defaultProps = {
  className: undefined,
  isAttachment: false,
  onClick: undefined,
};

export default Attachment;
