import React from 'react';
import { withHandlers } from 'recompose';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './styles.styles.scss';

const Important = ({ className, isImportant, onClick, readonly }) => (
  <span
    className={cx(
      css.notificationsFlag,
      isImportant && css.notificationsFlag_active,
      !readonly && css.notificationsFlag_editable,
      className,
    )}
    data-testid="MailImportantFlag"
    onClick={!readonly && onClick}
  >
    <i className="material-icons">flag</i>
  </span>
);

Important.propTypes = {
  className: PropTypes.string,
  isImportant: PropTypes.bool,
  readonly: PropTypes.bool,
  onClick: PropTypes.func,
};

Important.defaultProps = {
  className: undefined,
  isImportant: false,
  onClick: undefined,
  readonly: false,
};

export default withHandlers({
  onClick: ({ onClick }) => (e) => {
    e.stopPropagation();
    if (typeof onClick === 'function') {
      onClick(e);
    }
  },
})(Important);
