import React from 'react';
import { withHandlers } from 'recompose';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './styles.styles.scss';

const Unread = (args) => {
  const { className, isUnread, onClick } = args;

  return (
    <span
      className={cx(css.notificationsNew, isUnread && css.notificationsNew_active, className)}
      data-testid="Mail__readButton"
      onClick={onClick}
    >
      <i className="material-icons">lens</i>
    </span>
  );
};

Unread.propTypes = {
  className: PropTypes.string,
  isUnread: PropTypes.bool,
  onClick: PropTypes.func,
};

Unread.defaultProps = {
  className: undefined,
  isUnread: false,
  onClick: undefined,
};

export default withHandlers({
  onClick: ({ onClick }) => (e) => {
    e.stopPropagation();
    if (typeof onClick === 'function') {
      onClick(e);
    }
  },
})(Unread);
