import React from 'react';
import PropTypes from 'prop-types';

const withField = (WrappedComponent) => {
  const ImportantWithField = ({ className, input: { value, onChange } }) => (
    <WrappedComponent
      className={className}
      isImportant={value}
      onClick={() => {
        onChange(!value);
      }}
    />
  );

  ImportantWithField.propTypes = {
    className: PropTypes.string,
    input: PropTypes.instanceOf(Object),
  };

  ImportantWithField.defaultProps = {
    className: undefined,
    input: {},
  };

  return ImportantWithField;
};

export default withField;
