import get from 'lodash/get';
import { NAME } from './constants';
import { getCallState } from './selectors';
import * as api from './api';

export const MOUNT = `${NAME}MOUNT`;
export const mount = index => ({ type: MOUNT, index });
export const DESTROY = `${NAME}DESTROY`;
export const destroy = index => ({ type: DESTROY, index });

export const UPDATE = `${NAME}UPDATE`;
export const update = (data, index) => ({ type: UPDATE, data, index });

export const fetch = id => (dispatch, getState) => {
  dispatch(mount(id));
  return api.fetch(id).then((data) => {
    if (get(getCallState(getState(), id), 'mounted')) {
      dispatch(update(data, id));
    }
  });
};
