import { connect } from 'react-redux';
import loader from 'hoc/loader';
import View from 'components/Mail';
import { NAME } from '../constants';
import * as a from '../actions';

const mapState = (state, props) => ({
  ...(state[NAME][props.id] && state[NAME][props.id].data),
  loaderRenderWrapped: (state[NAME][props.id] && state[NAME][props.id].isLoad) || false,
});

const mapDispatch = (dispatch, props) => ({
  onMount: () => dispatch(a.fetch(props.id)),
  onUnmount: () => dispatch(a.destroy(props.id)),
});

export default connect(mapState, mapDispatch)(loader()(View));
