import * as a from './actions';

const INIT_STATE = {
  mounted: 0,
};

export default (state = INIT_STATE, action) => {
  switch (action.type) {
    case a.UPDATE: {
      return {
        ...state,
        data: action.data,
        isLoad: true,
      };
    }
    case a.MOUNT: {
      return { ...state, mounted: state.mounted + 1 };
    }
    case a.DESTROY: {
      const newMounted = state.mounted - 1;
      if (!newMounted) {
        return undefined;
      }
      return { mounted: newMounted };
    }
    default: {
      return state;
    }
  }
};
