import { baseCallApi, jsonApiCall } from 'api/common';
import * as aTypes from '../actionTypes/massmail';

export const loadContacts = (massmailId, accountId) => () =>
  baseCallApi({
    url: '/view/massmail/recipients/accountkik/list',
    data: { massmailId, accountId },
  });

export const updateAccountsWithSync = (massmailId, contactFilter) => ({
  type: 'PROMISE',
  actions: [
    aTypes.UPDATE_ACCOUNTS_REQUEST,
    aTypes.UPDATE_ACCOUNTS_RECEIVE,
    aTypes.UPDATE_ACCOUNTS_FAIL,
  ],
  promise: jsonApiCall({
    url: '/actions/massmail/recipients/list/update',
    data: { massmailId, contactFilter },
  }),
});

export const updateAccounts = (massmailId) => updateAccountsWithSync(massmailId);

export const getAccounts = (massmailId) => ({
  type: 'PROMISE',
  actions: [
    aTypes.UPDATE_ACCOUNTS_REQUEST,
    aTypes.UPDATE_ACCOUNTS_RECEIVE,
    aTypes.UPDATE_ACCOUNTS_FAIL,
  ],
  promise: baseCallApi({
    url: '/view/massmail/recipients/list',
    data: { massmailId },
  }),
});

export const addAccount = (massmailId, client) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/recipients/account/add',
    data: { massmailId, accountId: client.id },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};

export const removeAccount = (massmailId, accountId) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/recipients/account/delete',
    data: { massmailId, accountId },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};

export const addContact = (massmailId, accountKikId) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/recipients/accountkik/add',
    data: { massmailId, accountKikId },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};

export const removeContact = (massmailId, recipientId) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/recipients/accountkik/delete',
    data: { recipientId },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};

export const changeFilter = (massmailId, filter) => (dispatch) => {
  const filterKey = Object.keys(filter)[0];
  if (filterKey && filter[filterKey]) {
    dispatch(updateAccountsWithSync(massmailId, filter));
  }
  dispatch({ type: aTypes.CHANGE_FILTER, payload: filter });
};

export const changeRecipientsDuplicate = (massmailId, canDuplicate) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/setRecipientsDuplicate',
    data: { massmailId, canDuplicate },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};

export const changeGeneralAccountMail = (massmailId, generalAccountMail) => (dispatch) => {
  jsonApiCall({
    url: '/actions/massmail/setGeneralAccountMail',
    data: { massmailId, generalAccountMail },
  }).then(() => {
    dispatch(getAccounts(massmailId));
  });
};
