import { apiUploadFilesCall } from 'api/common';
import actons from 'actions';
import * as aTypes from '../actionTypes/massmail';
import { updateMassmail } from './massmail';
import { getMassmailId } from '../selectors';

export const onChange = e => (dispatch, getState) => {
  const massmailId = getMassmailId(getState());
  const files = e.target.files;

  return apiUploadFilesCall('/actions/massmail/upload/csv', { files, massmailId })
    .then((data) => {
      if (data) {
        if (!(Array.isArray(data.errors) && data.errors.length)) {
          dispatch(actons.uiToggleSnackbar(
            true,
            `Загружено строк: ${data.importedRowsCount}`,
            'SUCCESS',
          ));
        } else {
          dispatch({ type: aTypes.CSV_LOAD, payload: data });
        }
      }

      dispatch(updateMassmail(massmailId));
    });
};

export const destroy = () => ({ type: aTypes.CSV_DESTROY });
