import { baseCallApi } from 'api/common';
import * as aTypes from '../actionTypes/preview';

export const load = id => ({
  type: 'PROMISE',
  actions: [
    aTypes.PREVIEW_LOAD_REQUEST,
    aTypes.PREVIEW_LOAD_RECEIVE,
    aTypes.PREVIEW_LOAD_FAIL,
  ],
  promise: baseCallApi({ url: '/view/massmail/preview', data: { recipientId: id } }),
  meta: { name: id },
});

export const destroy = id => ({ type: aTypes.PREVIEW_DESTROY, meta: { name: id } });
