import React from 'react';
import PropTypes from 'prop-types';
import Select from '@crm/components/dist/lego2/Select';
import cx from 'classnames';
import TagsWithAdd from 'modules/tags/components/TagsWithAdd';
import SelectPosition from './SelectPosition';
import css from './Filter.modules.scss';
import withUseTagsForEmails from './hoc/withUseTagsForEmails';
import { getTags } from '../../../tags/actions';

const getContactCommMediumLinkTags = () => getTags({ type: 'ContactCommMediumLinkTag' });

const data = {
  one: [
    {
      value: 'isMassmail',
      content: 'Для рассылок',
    },
    {
      value: 'position',
      content: 'Должность',
    },
    {
      value: 'lastContact',
      content: 'Последний, с кем я общался',
    },
    {
      value: 'mostPopular',
      content: 'Самый популярный',
    },
    {
      value: 'all',
      content: 'Все',
    },
  ],
};

const emailTagsOption = {
  value: 'emailTags',
  content: 'С метками на email',
};

const complexFilterNames = ['position', 'emailTags'];

class MassmailAccountsSelectType extends React.Component {
  handleChangeType = (value) => {
    this.handleChangeFilter('type', value);
  };

  handleChangePosition = (value) => {
    this.handleChangeFilter('position', value);
  };

  handleAddTag = (tagId, tag) => {
    const { filter } = this.props;
    const newValue = filter.emailTags ? [...filter.emailTags, tag] : [tag];
    this.handleChangeFilter('emailTags', newValue);
  };

  handleRemoveTag = (tagId) => {
    const { filter } = this.props;
    if (Array.isArray(filter.emailTags)) {
      const newValue = filter.emailTags.filter((tag) => tag.id !== tagId);
      this.handleChangeFilter('emailTags', newValue);
    }
  };

  handleChangeFilter = (type, newValue) => {
    const filter = {};
    if (type === 'type') {
      if (newValue) {
        if (!complexFilterNames.includes(newValue)) {
          filter[newValue] = true;
        } else {
          filter[newValue] = null;
        }
      }
    } else {
      filter[type] = newValue;
    }
    this.props.onChange(filter);
  };

  render() {
    const { className, filter, readonly, isUseTagsForEmails } = this.props;
    const filterKey = Object.keys(filter)[0];
    const options = isUseTagsForEmails ? [...data.one, emailTagsOption] : data.one;
    const typeValue = filterKey || undefined;
    let complexValue;
    if (filterKey) {
      if (complexFilterNames.includes(filterKey)) {
        const value = filter[filterKey];
        if (value) {
          complexValue = value;
        }
      }
    }

    return (
      <div className={cx(className, css.root)}>
        <div className={css.row}>
          <div className={css.label}>Тип контакта:</div>
          <div className={css.control}>
            <Select
              name="type"
              size="xs"
              value={typeValue}
              placeHolder="–"
              onChange={this.handleChangeType}
              disabled={readonly}
              hasEmptyValue={false}
              options={options}
            />
          </div>
        </div>
        {filterKey === 'position' && (
          <div className={css.row}>
            <div className={css.label}>Должность:</div>
            <div className={css.control}>
              <SelectPosition
                name="position"
                size="xs"
                value={complexValue}
                placeholder="–"
                onChange={this.handleChangePosition}
                disabled={readonly}
              />
            </div>
          </div>
        )}
        {filterKey === 'emailTags' && (
          <div className={css.row}>
            <TagsWithAdd
              onLoad={getContactCommMediumLinkTags}
              onAdd={this.handleAddTag}
              onRemove={this.handleRemoveTag}
              canEdit
              tags={complexValue}
              canCreate={false}
            />
          </div>
        )}
      </div>
    );
  }
}

MassmailAccountsSelectType.propTypes = {
  className: PropTypes.string,
  filter: PropTypes.objectOf(PropTypes.any),
  readonly: PropTypes.bool,
};

MassmailAccountsSelectType.defaultProps = {
  className: undefined,
  filter: {},
  readonly: false,
};

export default withUseTagsForEmails(MassmailAccountsSelectType);
