import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { ModalForm as ClientFind } from 'modules/clientSelectForm';
import css from './HeaderMenu.modules.scss';
import LoadCsv from '../../containers/LoadCsv';

const MassmailAccountsMenu = (props) => {
  const { className, onAccount } = props;

  return (
    <div className={cx(className, css.root)}>
      <span className={css.label}>Добавить:</span>
      <ClientFind
        name="SEARCH_CLIENT"
        onSubmit={onAccount}
      >
        {
          (modal, open) => (
            <a
              className={css.item}
              tabIndex="0"
              onClick={open}
            >
              Аккаунт
              {modal}
            </a>
          )
        }
      </ClientFind>
      <LoadCsv
        inputComponent="a"
        inputComponentProps={{
          tabIndex: 0,
          className: css.item,
        }}
      >
        Из файла
      </LoadCsv>
    </div>
  );
};

MassmailAccountsMenu.propTypes = {
  className: PropTypes.string,
  onAccount: PropTypes.func,
};

MassmailAccountsMenu.defaultProps = {
  className: undefined,
  onAccount: () => {},
};

export default MassmailAccountsMenu;
