import React from 'react';
import PropTypes from 'prop-types';
import { Link as RouterLink } from 'react-router-dom';
import { accountLink } from 'pages/accounts/utils/linkCreator';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import AddContact from './ItemAddContact';
import Contacts from './ItemContacts';
import Warning from './Warning';
import css from './Item.modules.scss';

const MassmailAccountsItem = (props) => {
  const {
    className,
    contacts,
    account,
    onDeleteGroup,
    onDeleteContact,
    contactProps,
    addContact,
    loadContacts,
    readonly,
  } = props;

  return (
    <div className={cx(className, css.root)}>
      <header className={css.header}>
        <div className={css.headerContent}>
          {account.warnings && <Warning className={css.warning} {...account.warnings} />}
          <div className={css.name}>{account.name}</div>
          <div className={css.actions}>
            <RouterLink
              className={css.account}
              to={accountLink(account.id)}
              title={account.login || 'карточка аккаунта'}
              target="_blank"
            >
              {account.login || 'карточка'}
            </RouterLink>
            {!readonly && (
              <div className={css.addContact}>
                <AddContact
                  rootComponent="a"
                  loadContacts={() => loadContacts(account.id)}
                  addContact={addContact}
                >
                  <i className="material-icons" title="Добавить контакт">
                    person_add
                  </i>
                </AddContact>
              </div>
            )}
          </div>
          {!readonly && (
            <div className={css.removeAccount}>
              <Button
                view="clear"
                size="xs"
                title="Удалить группу из списка"
                onClick={() => onDeleteGroup(account.id)}
                icon={(className) => <Icon className={className} type="cross" />}
              />
            </div>
          )}
        </div>
      </header>
      <Contacts
        className={css.content}
        classNameItem={css.item}
        contacts={contacts}
        onDeleteContact={onDeleteContact}
        {...contactProps}
        readonly={readonly}
      />
    </div>
  );
};

MassmailAccountsItem.propTypes = {
  className: PropTypes.string,
  account: PropTypes.shape({
    name: PropTypes.string,
    warnings: PropTypes.shape({
      totalType: PropTypes.string,
      items: PropTypes.arrayOf(
        PropTypes.shape({
          type: PropTypes.string,
          warningMessage: PropTypes.string,
        }),
      ),
    }),
  }),
  contacts: PropTypes.arrayOf(PropTypes.instanceOf(Object)),
  onDeleteGroup: PropTypes.func,
  onAddContact: PropTypes.func,
  onDeleteContact: PropTypes.func,
  readonly: PropTypes.bool,
};

MassmailAccountsItem.defaultProps = {
  className: undefined,
  account: {
    name: undefined,
  },
  contacts: [],
  onDeleteGroup: () => {},
  onAddContact: () => {},
  onDeleteContact: () => {},
  readonly: false,
};

export default MassmailAccountsItem;
