import React from 'react';
import PropTypes from 'prop-types';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import Contacts from './ItemContacts';
import css from './ItemAddContact.modules.scss';

class AddContactPopup extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      items: [],
      isLoad: false,
    };
  }

  componentDidMount() {
    this.props.loadContacts().then((data) => {
      this.setState({ items: data, isLoad: true });
      this.props.onLoad();
    });
  }

  render() {
    if (!this.state.isLoad) {
      return <span className={css.loading}>Загрузка...</span>;
    }

    if (this.state.isLoad && !this.state.items.length) {
      return <span className={css.empty}>Нет контактов для добавления</span>;
    }

    return (
      <Contacts
        className={css.contacts}
        classNameItem={css.contactsItem}
        contacts={this.state.items}
        onContactClick={this.props.onContactClick}
      />
    );
  }
}

class AddContact extends React.Component {
  handleContactClick = (...args) => {
    this.props.addContact(...args);
    this.hidePopup();
  };

  // нужно для shouldUpdatePosition и правильного позиционирования
  handleRepositionOnLoad = () => {
    this.forceUpdate();
  };

  render() {
    const { rootComponent: RootComponent, loadContacts, children } = this.props;

    return (
      <ImperativePopup
        content={(popupBag) => {
          this.hidePopup = popupBag.hide;
          return (
            <AddContactPopup
              onContactClick={this.handleContactClick}
              loadContacts={loadContacts}
              onLoad={this.handleRepositionOnLoad}
            />
          );
        }}
        childrenClassName={css.popup}
        toggle={() => <RootComponent>{children}</RootComponent>}
        zIndex={100}
      />
    );
  }
}

AddContact.propTypes = {
  loadContacts: PropTypes.func.isRequired,
  addContact: PropTypes.func.isRequired,
};

export default AddContact;
