import React from 'react';
import { ContactCompact } from 'components/Contact';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import Status from '../Status';
import Warning from './Warning';
import css from './ItemContacts.modules.scss';

const Contacts = ({
  className,
  classNameItem,
  contacts,
  onDeleteContact,
  onContactClick,
  recipientId,
  readonly,
}) => (
  <div className={className}>
    {contacts.map((contact) => (
      <div
        key={contact.id}
        className={cx(classNameItem, css.item, recipientId === contact.id ? css.item_active : null)}
        onClick={
          onContactClick &&
          (() => {
            onContactClick(contact.id);
          })
        }
      >
        <Status className={css.status} type={contact.state} />
        <Warning className={css.warning} {...contact.warnings} />
        <ContactCompact className={css.content} contact={contact} />
        {!readonly && onDeleteContact && (
          <div className={css.removeContact}>
            <Button
              view="clear"
              size="xs"
              title="Удалить контакт из списка"
              onClick={() => onDeleteContact(contact.id)}
              icon={(className) => <Icon className={className} type="cross" />}
            />
          </div>
        )}
      </div>
    ))}
  </div>
);

export default Contacts;
