import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import ListItem from './Item';
import css from './List.modules.scss';

const MassmailAccountsList = (props) => {
  const { className, items, accountProps, contactProps, readonly } = props;
  return (
    <div className={cx(className, css.root)}>
      {
        items.map(item => (
          <ListItem
            className={css.item}
            key={item.account.id}
            contactProps={contactProps}
            readonly={readonly}
            {...accountProps}
            {...item}
          />
        ))
      }
    </div>
  );
};

MassmailAccountsList.propTypes = {
  className: PropTypes.string,
  items: PropTypes.arrayOf(PropTypes.shape(ListItem.propTypes)),
  readonly: PropTypes.bool,
};

MassmailAccountsList.defaultProps = {
  className: undefined,
  items: [],
  readonly: false,
};

export default MassmailAccountsList;
