import React from 'react';
import Select from '@crm/components/dist/lego2/Select';
import { apiCall } from 'api/common';

class SelectPosition extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      items: [],
    };
  }

  componentDidMount() {
    apiCall('/view/dicts/position').then((data) => {
      this.setState({ items: data.items });
    });
  }

  render() {
    return (
      <Select
        {...this.props}
        options={this.state.items.map((item) => ({ value: String(item.id), content: item.name }))}
      />
    );
  }
}

export default SelectPosition;
