import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './TotalContacts.modules.scss';

const MassmailAccountsSelectedTotal = ({ className, total }) => (
  <div className={cx(className, css.root)}>
    Количество получателей:
    <span className={css.total}>
      {total}
    </span>
  </div>
);

MassmailAccountsSelectedTotal.propTypes = {
  className: PropTypes.string,
  total: PropTypes.number,
};

MassmailAccountsSelectedTotal.defaultProps = {
  className: undefined,
  total: 0,
};

export default MassmailAccountsSelectedTotal;
