import React from 'react';
import PropTypes from 'prop-types';
import ToolTip from 'lego/components/ToolTip';
import cx from 'classnames';
import css from './Warning.modules.scss';

const RenderWarnings = warnings =>
  warnings.map((item, index) => (
    <div key={index} className={css.message}>
      <i className={cx('material-icons', css.messageIcon, css[`messageIcon_${item.type}`])}>
        priority_high
      </i>
      {item.message}
    </div>
  ));

const MassmailAccountsWarning = props => {
  const { className, totalType, items } = props;

  return items.length > 0 ? (
    <ToolTip
      tooltip={RenderWarnings(items)}
      padding="xs"
      stopPropagation
      className={cx(className, css.root, css[`root_${totalType}`])}
    >
      <i className="material-icons">warning</i>
    </ToolTip>
  ) : null;
};

MassmailAccountsWarning.propTypes = {
  className: PropTypes.string,
  totalType: PropTypes.string,
  items: PropTypes.arrayOf(
    PropTypes.shape({
      type: PropTypes.string,
      message: PropTypes.string,
    }),
  ),
};

MassmailAccountsWarning.defaultProps = {
  className: undefined,
  totalType: 'warning',
  items: [],
};

export default MassmailAccountsWarning;
