import React from 'react';
import PropTypes from 'prop-types';
import FileInput from 'lego/components/FileInput';
import Modal from '@crm/components/dist/lego2/Modal';
import CsvErrors from './CsvErrors';

const Csv = ({ show, data, onChange, destroy, ...passPropsThrough }) => (
  <span>
    <FileInput onChange={onChange} {...passPropsThrough} />
    <Modal
      visible={show}
      onClose={destroy}
      size="mid"
      title="Файл импортирован с ошибками"
      autoZIndex
      storeLastChildrenWhenClose
    >
      {show && <CsvErrors {...data} />}
    </Modal>
  </span>
);

CsvErrors.propTypes = {
  errors: PropTypes.shape(CsvErrors.propTypes),
};

export default Csv;
