import React from 'react';
import PropTypes from 'prop-types';
import css from './Csv.modules.scss';

const CsvErrors = ({ importedRowsCount, failedRowsCount, totalRowsCount, errors }) => (
  <div className={css.errors}>
    <div className={css.info}>
      <div className={css.errors__count_total}>
        Всего строк в файле
        <span className={css.count__number}>{totalRowsCount}</span>
      </div>
      <div className={css.errors__count_success}>
        Строк импортировано
        <span className={css.count__number}>{importedRowsCount}</span>
      </div>
      <div className={css.errors__count_failed}>
        Строк с ошибками
        <span className={css.count__number}>{failedRowsCount}</span>
      </div>
    </div>
    <div className={css.errors__list}>
      {errors.map(error => <div key={error} className={css.errors__error}>{error}</div>)}
    </div>
  </div>
);

CsvErrors.propTypes = {
  importedRowsCount: PropTypes.number.isRequired,
  failedRowsCount: PropTypes.number.isRequired,
  totalRowsCount: PropTypes.number.isRequired,
  errors: PropTypes.arrayOf(PropTypes.string).isRequired,
};

export default CsvErrors;
