import React from 'react';
import PropTypes from 'prop-types';
import Prompt from '../Prompt';
import MassmailList from '../Massmails';
import css from './styles.modules.scss';

const MassmailLayout = ({ onNewMassmail, onChangeMassmail, children, massmailId }) => (
  <div className={css.root}>
    <Prompt />
    <div className={css.content}>
      <div className={css.list}>
        <div className={css.header}>
          <div className={css.title}>Рассылки</div>
          <a tabIndex="0" onClick={onNewMassmail} className={css.addNew}>
            Новая рассылка
          </a>
        </div>
        <MassmailList
          className={css.Massmail}
          massmailId={massmailId}
          onChange={onChangeMassmail}
        />
      </div>
      {children}
    </div>
  </div>
);

MassmailLayout.propTypes = {
  onNewMassmail: PropTypes.func.isRequired,
  onChangeMassmail: PropTypes.func.isRequired,
  children: PropTypes.node,
  massmailId: PropTypes.number,
};

MassmailLayout.defaultProps = {
  children: null,
  massmailId: undefined,
};

export default MassmailLayout;
