import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { MailFormMassmail } from 'modules/newMail';
import Button from '@crm/components/dist/lego2/Button';
import { Toolbar2 } from 'components/Toolbar2';
import { config } from 'services/Config';
import Mail from 'components/Mail';
import Accounts from '../Accounts';
import css from './styles.modules.scss';
import { createMassmailInput } from '../MassmailInput';

const fields = {
  from: true,
  subject: true,
  files: true,
  macros: true,
  cc: true,
};

const displayNone = {
  visible: 'hidden',
  position: 'absolute',
  left: -9999,
};

const MassmailMailLayout = (props) => {
  const {
    className,
    isLoad,
    isFetch,
    data,
    preview,
    updateAccounts,
    addAccount,
    removeAccount,
    changeFilter,
    removeContact,
    addContact,
    saveMassmail,
    removeMassmail,
    loadContacts,
    previewDestroy,
    loadPreview,
    sendMassmail,
    cloneMassmail,
    changeRecipientsDuplicate,
    changeGeneralAccountMail,
  } = props;

  if (!isLoad) {
    return null;
  }

  const isSent = data.mail.type === 'Sent';
  const isPreview = preview.isLoad;

  let accountsProps = {};
  if (isPreview) {
    accountsProps = {
      ...preview.data.recipientViewItem,
      contactProps: {
        onContactClick: loadPreview,
        recipientId: preview.recipientId,
      },
    };
  } else {
    accountsProps = {
      ...data.recipientViewItem,
    };
  }

  return (
    <div className={cx(className, css.root)}>
      <Accounts
        {...accountsProps}
        className={css.accountsList}
        refresh={updateAccounts}
        changeFilter={changeFilter}
        onAccount={addAccount}
        onClone={cloneMassmail}
        onDuplicateChange={changeRecipientsDuplicate}
        onGeneralAccountMailChange={changeGeneralAccountMail}
        accountProps={{
          onDeleteGroup: removeAccount,
          onDeleteContact: removeContact,
          addContact,
          loadContacts,
        }}
        readonly={isPreview || isSent}
        allowClone={isSent}
      />
      {isPreview && (
        <div className={css.Preview}>
          <Mail
            className={css.Preview__mail}
            theme="MAIL_MODULE"
            objectType="massmail"
            key={preview.data.recipientId}
            {...preview.data.mail}
          />
          <Toolbar2
            left={
              <>
                <Button view="danger" onClick={sendMassmail}>
                  Отправить
                </Button>
                <Button view="clear" onClick={previewDestroy}>
                  Редактировать
                </Button>
              </>
            }
          />
        </div>
      )}
      {isSent ? (
        <div className={css.Preview}>
          <Mail theme="MAIL_MODULE" key="MASSMAIL" objectType="massmail" {...data.mail} />
        </div>
      ) : (
        <MailFormMassmail
          className={css.newsletter}
          style={isPreview ? displayNone : undefined}
          onSubmit={saveMassmail}
          onCancel={removeMassmail}
          macros={data.macros}
          resizeHash={isPreview}
          name="MASSMAIL"
          initialValues={{
            ...data.mail,
            from: '0',
          }}
          type={data.mail.type === 'Draft' ? 'draft' : ''}
          isLoad={isLoad && !isFetch}
          files={data.mail.files}
          froms={data.froms}
          fields={{
            ...fields,
            cc: config.value.features.massMailImprovements,
          }}
          objectName="massmail"
          buttonTextSend="Просмотреть и отправить"
          disabledSend={!data.recipientViewItem.allowSend}
          buttonTextCancel="Удалить"
          objId={data.mail.id}
          clearHtmlOnSend={false}
          showLabels={false}
          showPlaceholders
          EmailInput={createMassmailInput(data.mail.id)}
        />
      )}
    </div>
  );
};

MassmailMailLayout.propTypes = {
  className: PropTypes.string,
  isLoad: PropTypes.bool,
  isFetch: PropTypes.bool,
  data: PropTypes.objectOf(PropTypes.any),
  preview: PropTypes.objectOf(PropTypes.any),
  updateAccounts: PropTypes.func.isRequired,
  addAccount: PropTypes.func.isRequired,
  removeAccount: PropTypes.func.isRequired,
  changeFilter: PropTypes.func.isRequired,
  removeContact: PropTypes.func.isRequired,
  addContact: PropTypes.func.isRequired,
  saveMassmail: PropTypes.func.isRequired,
  removeMassmail: PropTypes.func.isRequired,
  loadContacts: PropTypes.func.isRequired,
  previewDestroy: PropTypes.func.isRequired,
  loadPreview: PropTypes.func.isRequired,
  sendMassmail: PropTypes.func.isRequired,
  cloneMassmail: PropTypes.func,
};

MassmailMailLayout.defaultProps = {
  className: '',
  isLoad: false,
  isFetch: false,
  data: undefined,
  preview: undefined,
};

export default MassmailMailLayout;
