import React from 'react';
import PropTypes from 'prop-types';
import Empty from 'components/Empty';
import { InfiniteListView } from 'containers/InfiniteList';
import { loadMassmailList } from 'modules/massmail/actions/layout';
import ListHeader from './ListHeader';
import ListItem from './ListItem';

const massmailEmpty = (
  <Empty
    text="Рассылок нет"
    icon={null}
  />
);

const renderList = ({ className, items = [], onClick, noHeaders }) => {
  if (!items.length === 0) {
    return null;
  }

  let currentType;

  return items.map((item) => {
    const type = item.type;

    const ItemNode = (
      <ListItem
        key={`item${item.id}`}
        id={item.id}
        className={className}
        data={item}
        onClick={onClick}
      />
    );

    if (!noHeaders && type !== currentType) {
      currentType = type;

      const HeaderNode = (
        <ListHeader
          key={`header${type}`}
          type={type}
        />
      );

      return [HeaderNode, ItemNode];
    }

    return ItemNode;
  });
};


class MassmailList extends React.Component {
  load = (args) => {
    const { onlyDraft } = this.props;
    if (onlyDraft) {
      return loadMassmailList({ onlyDraft, ...args });
    }

    return loadMassmailList(args);
  };

  render() {
    const passPropsThrough = { ...this.props };
    delete passPropsThrough.classNameItem;
    delete passPropsThrough.onlyDraft;
    delete passPropsThrough.onClick;
    delete passPropsThrough.massmailId;
    delete passPropsThrough.noHeaders;

    return (
      <InfiniteListView
        name="MASS_MAIL_LIST"
        onLoad={this.load}
        loadOnMount
        emptyComponent={massmailEmpty}
        selectedId={this.props.massmailId}
        withNavigation={!this.props.noHeaders}
        {...passPropsThrough}
      >
        {listProps => renderList({
          items: listProps.items,
          className: this.props.classNameItem,
          onClick: this.props.onClick,
          noHeaders: this.props.noHeaders,
        })}
      </InfiniteListView>
    );
  }
}

MassmailList.propTypes = {
  className: PropTypes.string,
  classNameItem: PropTypes.string,
  onClick: PropTypes.func,
  onlyDraft: PropTypes.bool,
  massmailId: PropTypes.number,
  noHeaders: PropTypes.bool,
};

MassmailList.defaultProps = {
  className: undefined,
  classNameItem: undefined,
  onClick: undefined,
  onlyDraft: false,
  massmailId: undefined,
  noHeaders: false,
};

export default MassmailList;
