import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import { Link } from 'react-router-dom';
import cx from 'classnames';
import TitleChain from 'modules/heading';
import Status from '../Status';
import css from './ListItem.modules.scss';

const MassmailListItem = props => {
  const {
    className,
    data: { subject, type, state, date, id },
    recipients,
    views,
    onClick,
    selected,
  } = props;

  const Component = onClick ? 'div' : Link;
  const componentProps = onClick
    ? {
        onClick: () => {
          onClick(id);
        },
      }
    : { to: `/massmail/${id}` };

  return (
    <Component
      {...componentProps}
      className={cx(className, css.root, css[`root_status_${type}`], selected && css.selected)}
    >
      {selected && <TitleChain>{subject}</TitleChain>}
      <div className={css.content}>
        <div className={css.name}>
          <Status className={css.status} type={state} />
          {subject}
        </div>
        <div className={css.date}>
          <FormattedDate
            value={new Date(date)}
            day="numeric"
            month="numeric"
            year="numeric"
            hour="numeric"
            minute="numeric"
          />
        </div>
      </div>
      {(recipients || views) && (
        <div className={css.info} title={`Реципиентов: ${recipients}`}>
          {recipients && (
            <div className={css.recipients}>
              <i className="material-icons">person</i>
              <span className={css.info_text}>{recipients}</span>
            </div>
          )}
          {views && (
            <div className={css.views} title={`Просмотров: ${recipients}`}>
              <i className="material-icons">visibility</i>
              <span className={css.info_text}>{views}</span>
            </div>
          )}
        </div>
      )}
    </Component>
  );
};

MassmailListItem.propTypes = {
  className: PropTypes.string,
  selected: PropTypes.bool,
  data: PropTypes.shape({
    subject: PropTypes.string.isRequired,
    date: PropTypes.string.isRequired,
    type: PropTypes.string.isRequired,
    id: PropTypes.number.isRequired,
  }).isRequired,
  recipients: PropTypes.number,
  views: PropTypes.number,
  onClick: PropTypes.func,
};

MassmailListItem.defaultProps = {
  selected: false,
  onClick: undefined,
  className: undefined,
  name: 'Рассылка',
  recipients: undefined,
  views: undefined,
};

export default MassmailListItem;
