import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import List from './List';

const ListWithNew = ({
  className,
  classNameItem,
  classNameNewComponent,
  newComponent,
  onClick,
  onlyDraft,
  noHeaders,
}) => (
  <div>
    <List
      className={className}
      classNameItem={classNameItem}
      onClick={onClick}
      onlyDraft={onlyDraft}
      noHeaders={noHeaders}
    />
    {createElement(
      newComponent,
      {
        className: classNameNewComponent,
        onClick: () => {
          onClick();
        },
      },
      'Новая рассылка',
    )}
  </div>
);

ListWithNew.propTypes = {
  className: PropTypes.string,
  classNameItem: PropTypes.string,
  classNameNewComponent: PropTypes.string,
  newComponent: PropTypes.oneOfType([PropTypes.string, PropTypes.func]),
  onClick: PropTypes.func.isRequired,
  onlyDraft: PropTypes.bool,
  noHeaders: PropTypes.bool,
};

ListWithNew.defaultProps = {
  className: undefined,
  classNameItem: undefined,
  classNameNewComponent: undefined,
  newComponent: 'button',
  onlyDraft: false,
  noHeaders: false,
};

export default ListWithNew;
