import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import List from './List';
import css from './Massmails.modules.scss';

const MassmailListLayout = (props) => {
  const {
    className,
    massmailId,
    onChange,
  } = props;

  return (
    <div className={cx(className, css.root)}>
      <List
        onChange={onChange}
        className={css.list}
        massmailId={massmailId}
      />
    </div>
  );
};

MassmailListLayout.propTypes = {
  onChange: PropTypes.func.isRequired,
  className: PropTypes.string,
  massmailId: PropTypes.number,
};

MassmailListLayout.defaultProps = {
  className: undefined,
  massmailId: undefined,
};

export default MassmailListLayout;
