import React from 'react';
import cx from 'classnames';
import css from './styles.modules.scss';

const MassmailStatus = ({ className, type }) => {
  let status;

  switch (type) {
    case 'Sending':
      status = { icon: 'timelapse', title: 'отправляется' };
      break;
    case 'Sent':
      status = { icon: 'check_circle', title: 'отправлено' };
      break;
    case 'Error':
      status = { icon: 'warning', title: 'ошибка' };
      break;
    default:
      status = null;
  }

  return status
    ? <span
        className={cx(className, css.status, css[`status_${type}`])}
        title={`Статус: ${status.title}`}
      >
        <i className="material-icons">{status.icon}</i>
      </span>
    : null;
};

export default MassmailStatus;
