import React from 'react';
import PropTypes from 'prop-types';
import isPromise from 'is-promise';
import { history } from 'appHistory';
import ListWithNew from '../components/Massmails/ListWithNew';

class ListWithNewContainer extends React.Component {
  redirect = massmailId => history.push(`/massmail/${massmailId}`);

  handleClick = massmailId => {
    const { props } = this;
    const result = props.onClick(massmailId);

    if (props.redirect) {
      if (isPromise(result)) {
        result.then(data => {
          if (data.massmailId) {
            this.redirect(data.massmailId);
          } else if (massmailId) {
            this.redirect(massmailId);
          }
        });
      } else if (massmailId) {
        this.redirect(massmailId);
      }
    }
  };

  render() {
    return <ListWithNew {...this.props} onClick={this.handleClick} />;
  }
}

ListWithNewContainer.propTypes = {
  redirect: PropTypes.bool,
  onClick: PropTypes.func.isRequired,
};

ListWithNewContainer.defaultProps = {
  redirect: false,
};

export default ListWithNewContainer;
