import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import loader from 'hoc/loader';
import bindName from 'utils/bindName';
import Massmail from '../components/MailLayout';
import * as accountActions from '../actions/accounts';
import { getMassmailState } from '../selectors';
import { STATE_NAME } from '../constants';
import reducers from '../reducers/massmail';
import {
  loadMassmail,
  saveMassmail,
  removeMassmail,
  previewDestroy,
  loadPreview,
  sendMassmail,
  cloneMassmail,
  destroy,
} from '../actions/massmail';

const instanceMassmailActions = {
  saveMassmail,
  previewDestroy,
  loadPreview,
  sendMassmail,
  cloneMassmail,
};

global.reduxStore.injectReducer(STATE_NAME, reducers);

const mapState = (state) => getMassmailState(state);
const mapDispatch = (dispatch, props) => ({
  onMount: () => dispatch(loadMassmail(props.massmailId)),
  onReceiveProps: (nextProps, currentProps) => {
    if (currentProps.massmailId) {
      if (nextProps.massmailId) {
        if (nextProps.massmailId !== currentProps.massmailId) {
          dispatch(loadMassmail(nextProps.massmailId));
        }
      } else {
        // destroy
      }
    }
  },
  onUnmount: bindActionCreators(destroy, dispatch),
  removeMassmail: () => dispatch(removeMassmail(props.massmailId, props.onRemove)),
  ...bindActionCreators(bindName(props.massmailId, instanceMassmailActions), dispatch),
  ...bindActionCreators(bindName(props.massmailId, accountActions), dispatch),
});

export default connect(mapState, mapDispatch)(loader()(Massmail));
