import { createElement, Component } from 'react';
import PropTypes from 'prop-types';
import Massmail from './Massmail';
import { ROUTER_PATH } from '../constants';

class MassmailRouter extends Component {
  handleRemove = () => {
    const unblock = this.props.history.block();
    unblock();
    this.props.history.push(ROUTER_PATH);
  };

  render() {
    const massmailId = parseInt(this.props.params.id, 10);

    return createElement(Massmail, {
      massmailId: massmailId || null,
      key: massmailId || 0,
      onRemove: this.handleRemove,
    });
  }
}

MassmailRouter.propTypes = {
  params: PropTypes.objectOf(PropTypes.any).isRequired,
  history: PropTypes.instanceOf(Object).isRequired,
};

export default MassmailRouter;
