import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import destroyDriver from 'utils/destroyDriver';
import bindName from 'utils/bindName';
import loader from 'hoc/loader';
import reducers from '../reducers/preview';
import { STATE_NAME_PREVIEW } from '../constants';
import { getPreview } from '../selectors';
import * as actions from '../actions/preview';
import Preview from '../components/Preview';

global.reduxStore.injectReducer(STATE_NAME_PREVIEW, reducers);

const mapState = (state, props) => {
  const instanceState = getPreview(state, props.id) || {};

  return {
    ...instanceState,
    loaderRenderWrapped: !!instanceState.isLoad,
  };
};
const mapDispatch = (dispatch, props) => bindActionCreators(bindName(props.id, actions), dispatch);

const connectorRedux = connect(mapState, mapDispatch);

const connectorDestroyDriver = destroyDriver({ slugName: 'id' });

const connectorLoader = loader({
  onMount(props) {
    props.load();
  },
  onUnmount(props) {
    if (props.destroyOnUnmount) {
      props.destroy();
    }
  },
});

export default connectorRedux(connectorDestroyDriver(connectorLoader(Preview)));
