import * as aTypes from 'modules/massmail/actionTypes/massmail';

const INIT_STATE = {};

const behaviors = {
  [aTypes.CSV_LOAD](state, { payload }) {
    return {
      ...state,
      show: true,
      data: payload,
    };
  },
  [aTypes.CSV_DESTROY]() {
    return INIT_STATE;
  },
};

const reducer = (state = INIT_STATE, action) => {
  const behavior = behaviors[action.type];
  return behavior ? behavior(state, action) : state;
};

export default reducer;
