import * as aTypes from 'modules/massmail/actionTypes/massmail';
import preview from './preview';
import csv from './csv';

const INIT_STATE = {};

const behaviors = {
  [aTypes.MASSMAIL_REQUEST](state) {
    return { ...state, isFetch: true };
  },
  [aTypes.MASSMAIL_RECEIVE](state, { data }) {
    return { ...state, isFetch: false, isLoad: true, data, preview: undefined };
  },
  [aTypes.MASSMAIL_UPDATE_RECEIVE](state, { data }) {
    return { ...state, data: { ...state.data, ...data } };
  },
  [aTypes.MASSMAIL_FAIL](state) {
    return { ...state, isFetch: false };
  },
  [aTypes.UPDATE_ACCOUNTS_RECEIVE](state, { data }) {
    return {
      ...state,
      data: {
        ...state.data,
        recipientViewItem: data,
      },
    };
  },
  [aTypes.CHANGE_FILTER](state, { payload }) {
    return {
      ...state,
      data: {
        ...state.data,
        recipientViewItem: {
          ...state.data.recipientViewItem,
          recipientFilter: payload,
        },
      },
    };
  },
  [aTypes.MASSMAIL_DESTROY]() {
    return INIT_STATE;
  },
};

const reducer = (state = INIT_STATE, action) => {
  const behavior = behaviors[action.type];
  let newState = behavior ? behavior(state, action) : state;
  newState = { ...newState, preview: preview(newState.preview, action) };
  newState = { ...newState, csv: csv(newState.csv, action) };
  return newState;
};

export default reducer;
