import * as aTypes from 'modules/massmail/actionTypes/massmail';

const INIT_STATE = {};

const behaviors = {
  [aTypes.PREVIEW_REQUEST](state) {
    return {
      ...state,
      isFetch: true,
    };
  },
  [aTypes.PREVIEW_RECEIVE](state, { data }) {
    return {
      ...state,
      isFetch: false,
      isLoad: true,
      data,
    };
  },
  [aTypes.PREVIEW_FAIL](state) {
    return {
      ...state,
      isFetch: false,
    };
  },
  [aTypes.PREVIEW_STORE_ARGS](state, { payload }) {
    return {
      ...state,
      args: payload,
    };
  },
  [aTypes.PREVIEW_STORE_RECIPIENT_ID](state, { payload }) {
    return {
      ...state,
      recipientId: payload,
    };
  },
  [aTypes.PREVIEW_DESTROY]() {
    return INIT_STATE;
  },
};

const reducer = (state = INIT_STATE, action) => {
  const behavior = behaviors[action.type];
  return behavior ? behavior(state, action) : state;
};

export default reducer;
