import arrayReducerFactoryRaw from 'utils/reducer/arrayReducerFactoryRaw';
import * as aTypes from '../actionTypes/preview';

const INIT_STATE = {};

const behaviors = {
  [aTypes.PREVIEW_LOAD_REQUEST](state) {
    return { ...state, isFetch: true };
  },
  [aTypes.PREVIEW_LOAD_RECEIVE](state, { data }) {
    return { ...state, isFetch: false, isLoad: true, ...data };
  },
  [aTypes.PREVIEW_LOAD_FAIL](state) {
    return { ...state, isFetch: false };
  },
  [aTypes.PREVIEW_DESTROY]() {
    return undefined;
  },
};

export default arrayReducerFactoryRaw(aTypes, behaviors, INIT_STATE);
