import React from 'react';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import Layout from './containers/Layout';
import MassmailRouter from './containers/MassmailRouter';
import { BACKEND_AUTHORIZATION_NAME } from './constants';

const Auth = moduleAuthorization(BACKEND_AUTHORIZATION_NAME)(Layout);

const MassmailRouter2 = props => (
  <Auth params={props.match.params}>
    <TitleChain>Рассылки</TitleChain>
    {props.match.params.id && (
      <MassmailRouter params={props.match.params} history={props.history} />
    )}
  </Auth>
);

export default MassmailRouter2;
