import get from 'lodash/get';
import { STATE_NAME, STATE_NAME_PREVIEW } from './constants';

export const getMassmailState = state => get(state, `${STATE_NAME}`);
export const getMassmailId = state => get(state, `${STATE_NAME}.data.mail.id`);
export const getFirstContantId = (state) => {
  const items = get(state, `${STATE_NAME}.data.recipientViewItem.items`, []);
  let firstContactId;

  for (let i = 0; i < items.length; i += 1) {
    firstContactId = get(items[i], 'contacts[0].id');
    if (firstContactId) {
      break;
    }
  }

  return firstContactId;
};

export const getIsLoadPreview = state =>
  get(state, `${STATE_NAME}.isLoad`);

export const getPreviewArgs = state =>
  get(state, `${STATE_NAME}.preview.args`);

export const getCsvErrors = state =>
  get(state, `${STATE_NAME}.csv`);

export const getPreview = (state, name) => get(state, `${STATE_NAME_PREVIEW}.${name}`);
