import React, { useMemo } from 'react';
import { useRouteMatch, Redirect, useHistory, Switch, Route } from 'react-router-dom';
import { Position, Tone } from '@crm/components/dist/Panel';
import { DynamicallyModalForm } from 'components/DynamicallyModalForm';
import Panel from 'modules/panel';
import { ROUTE_PATH } from '../constants';
import { PageList, getPageListItems } from './PageList';
import { ActivitiesPageProps } from './ActivitiesPage.types';
import css from './ActivitiesPage.module.css';

export const ActivitiesPage: React.FC<ActivitiesPageProps> = (props) => {
  const { date, setDate } = props;

  const history = useHistory();
  const match = useRouteMatch<{ pageId: string }>(`${ROUTE_PATH}/:pageId`);
  const pageListItems = useMemo(getPageListItems, []);

  const handleChange = (pageId: string) => {
    history.push(`${ROUTE_PATH}/${pageId}`);
  };

  return (
    <div className={css.ActivitiesPage}>
      <Panel
        position={Position.Left}
        tone={Tone.Superlight}
        defaultPin
        hasPinButton={false}
        defaultPanelId="activities"
        name="activities"
        forceNewDesign
        defaultSize={{
          width: 280,
        }}
        minWidth={200}
        maxWidth={300}
        panels={[
          {
            id: 'activities',
            title: 'Активности',
            mountMode: 'always',
            padding: false,
            content: <PageList page={match?.params?.pageId} onPageChange={handleChange} />,
          },
        ]}
      />

      <div className={css.ActivitiesPage__page}>
        <Switch>
          {pageListItems.map(({ id, Component }) => (
            <Route key={id} path={`${ROUTE_PATH}/${id}`}>
              <Component date={date} onDateChange={setDate} />
            </Route>
          ))}
          <Redirect to={`${ROUTE_PATH}/${pageListItems[0].id}`} />
        </Switch>
      </div>
      <DynamicallyModalForm />
    </div>
  );
};
