import React, { useState } from 'react';
import { View } from '@crm/react-big-calendar';
import { DateNavigator } from 'components/DateNavigator';
import RadioButton from '@crm/components/dist/lego2/RadioButton';
import { Layout } from '../Layout';
import { Calendar } from '../Calendar';
import { PageComponentProps } from '../PageList';
import { CalendarViewOptions } from './CalendarPage.config';
import css from './CalendarPage.module.css';

export const CalendarPage: React.FC<PageComponentProps> = ({ date, onDateChange }) => {
  const [view, setView] = useState<View>('week');

  return (
    <Layout title="Календарь">
      <div className={css.CalendarPage}>
        <div className={css.CalendarPage__controls}>
          <DateNavigator value={date} onChange={onDateChange} />
          <RadioButton
            value={view}
            width="auto"
            size="s"
            isEventValue={false}
            onChange={setView as (value: View) => void}
            options={CalendarViewOptions}
          />
        </div>
        <Calendar date={date} onNavigate={onDateChange} view={view} />
      </div>
    </Layout>
  );
};
