import React from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
// import { ActivityDropdown } from 'modules/meetings/Sidebar/ActivityDropdown';
import { LayoutProps } from './Layout.types';
import css from './Layout.module.css';

export const Layout: React.FC<LayoutProps> = ({ title, children }) => {
  return (
    <div className={css.Layout}>
      <div className={css.Layout__header}>
        <Text typography="subheader-s" weight="medium">
          {title}
        </Text>
        {/* https://st.yandex-team.ru/CRM-18851 */}
        {/* <ActivityDropdown /> */}
      </div>
      <div className={css.Layout__content}>{children}</div>
    </div>
  );
};
