import { config } from 'services/Config';
import { TodosPage } from '../TodosPage';
import { DoneActivitiesNew } from '../../DoneActivities';
import { CalendarPage } from '../CalendarPage';
import { PageListItem } from './PageList.types';

export const getPageListItems = () => {
  return [
    {
      id: 'todos',
      data: { label: 'Дела на день' },
      Component: TodosPage,
    },
    config.value.features.activityTab && {
      id: 'feed',
      data: { label: 'Лента активностей' },
      Component: DoneActivitiesNew,
    },
    {
      id: 'calendar',
      data: { label: 'Календарь' },
      Component: CalendarPage,
    },
  ].filter((item) => Boolean(item)) as PageListItem[];
};
