import React, { useMemo } from 'react';
import { TreeView } from 'components/TreeView';
import { PageListItem } from '../PageListItem';
import { getPageListItems } from './PageList.config';
import css from './PageList.module.css';
import { PageListProps } from './PageList.types';

export const PageList: React.FC<PageListProps> = ({ page, onPageChange }) => {
  const pageListItems = useMemo(getPageListItems, []);

  const handleChange = (pageId: string[]) => {
    onPageChange(pageId[0]);
  };

  const hasSelectedPage = pageListItems.some(({ id }) => id === page);
  if (!hasSelectedPage || !page) return null;

  return (
    <div className={css.PageList}>
      <TreeView
        onChange={handleChange}
        singleSelect
        ItemComponent={PageListItem}
        defaultSelected={[page]}
        items={pageListItems}
      />
    </div>
  );
};
