import React from 'react';
import cx from 'classnames';
import { Text } from '@crm/components/dist/lego2/Text';
import { ItemComponentProps, NodeData } from 'components/TreeView/TreeView.types';
import css from './PageListItem.module.css';

export const PageListItem: React.FC<ItemComponentProps<NodeData>> = (props) => {
  const isSelected = props.getIsSelected(props.id);

  const handleClick = () => {
    if (!isSelected) props.onSelect(props.id, props.isLeaf);
  };

  return (
    <div
      className={cx(css.PageListItem, { [css.PageListItem_selected]: isSelected })}
      onClick={handleClick}
    >
      <Text typography="body-long-m">{props.data.label}</Text>
    </div>
  );
};
