import React from 'react';
import { startOfDay, endOfDay } from 'date-fns';
import { DateNavigator } from 'components/DateNavigator';
import { Layout } from '../Layout';
import { Calendar } from '../Calendar';
import { PageComponentProps } from '../PageList';
import { TodoTable } from '../../Todos/TodoTable';
import { TABLE_SOURCE_URL } from '../../Todos/Main/Main.constants';
import css from './TodosPage.module.css';

export const TodosPage: React.FC<PageComponentProps> = ({ date, onDateChange }) => {
  const extendedQueryParams = {
    FromDate: startOfDay(date).toISOString(),
    ToDate: endOfDay(date).toISOString(),
  };

  return (
    <Layout title="Дела на день">
      <div className={css.TodosPage}>
        <div className={css.TodosPage__main}>
          <DateNavigator value={date} onChange={onDateChange} />
          <div className={css.TodosPage__tableWrap}>
            <TodoTable
              className={css.TodosPage__table}
              date={date}
              url={TABLE_SOURCE_URL}
              extendedQueryParams={extendedQueryParams}
            />
          </div>
        </div>
        <div className={css.TodosPage__calendar}>
          <Calendar date={date} />
        </div>
      </div>
    </Layout>
  );
};
