import React, { FC } from 'react';
import { Calendar } from 'modules/meetings/ActivitiesPage/Calendar';
import { MainProps } from './Main.types';
import css from './Main.module.css';

export const Main: FC<MainProps> = (props) => {
  const { date, onDateChange, calendarView } = props;

  return (
    <div className={css.Main}>
      <Calendar
        className={css.Main__calendar}
        date={date}
        onNavigate={onDateChange}
        view={calendarView}
        eventMinHeight={2}
      />
    </div>
  );
};
