import React, { FC } from 'react';
import { Sidebar as CommonSidebar } from '../../Sidebar';
import { SidebarProps } from './Sidebar.types';
import { AVAILABLE_VIEWS, VIEW_TEXT_MAP } from './Sidebar.constants';
import { ViewButton } from './ViewButton';
import css from './Sidebar.module.css';

export const Sidebar: FC<SidebarProps> = (props) => {
  const { date, calendarView, onCalendarView, onDateChange } = props;

  return (
    <CommonSidebar
      date={date}
      onDateChange={onDateChange}
      afterActivities={
        <div className={css.Sidebar__viewButtons}>
          {AVAILABLE_VIEWS.map((view) => (
            <ViewButton
              key={view}
              view={view}
              text={VIEW_TEXT_MAP[view]}
              onClick={onCalendarView}
              pressed={calendarView === view}
            />
          ))}
        </div>
      }
    />
  );
};
