import React, { FC } from 'react';
import cx from 'classnames';
import { Box } from 'components/design/ListItem/Box';
import { Text } from 'components/design/Text';
import { ViewButtonProps } from './ViewButton.types';
import css from './ViewButton.module.css';

export const ViewButton: FC<ViewButtonProps> = ({ text, view, onClick, pressed }) => {
  const handleClick = () => {
    onClick(view);
  };

  const className = cx({
    [css.ViewButton_pressed]: pressed,
  });

  return (
    <Box onClick={handleClick} className={className}>
      <Text>{text}</Text>
    </Box>
  );
};
